require( "HiddenObject/script/style.lua" );
WhiteColor = Color(173,193,161,255);
ButtonColor = Color(131,167,184,255);
-- gRows and gColumns are set up in mainmenu.lua
ButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  22,
  ButtonColor
};

RevealButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  18,
  ButtonColor
};

GoButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  30,
  ButtonColor
};


MastermindRevealButtonGraphics = {
	"Mastermind/UI/Button/revealnormal",
	"Mastermind/UI/Button/revealmousedown",
	"Mastermind/UI/Button/revealmouseover"
};


MastermindRevealButtonStyle = {
	parent = DefaultStyle,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = MastermindRevealButtonGraphics,
};

MastermindButtonGraphics = {
	"Mastermind/UI/Button/gomousenormal",
	"Mastermind/UI/Button/gomousedown",
	"Mastermind/UI/Button/gomouseover"
};

MastermindButtonStyle = {
	parent = DefaultStyle,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = MastermindButtonGraphics,
	flags = kVAlignCenter + kHAlignCenter,
}

MM_Graphics_Button= {
	"Mastermind/UI/Button/menunormal",
	"Mastermind/UI/Button/menumousedown",
	"Mastermind/UI/Button/menumouseover"
};


MM_Style_Button = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = MM_Graphics_Button,
	flags = kVAlignCenter + kHAlignCenter,
};


MM_Style_Button_Hint = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	type= kPush,
	graphics = MM_Graphics_Button,
	flags = kVAlignCenter + kHAlignCenter,
};

MM_Graphics_Skip = {
	"Mastermind/UI/Button/skipnormal",
	"Mastermind/UI/Button/skipmousedown",
	"Mastermind/UI/Button/skipmouseover"
};


MM_Style_Skip = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = MM_Graphics_Skip,
	flags = kVAlignCenter + kHAlignCenter,
};


FooterOkGraphics = {
	"Mastermind/UI/Button/okmousenormal",
	"Mastermind/UI/Button/okmousedown",
	"Mastermind/UI/Button/okmouseover"
};

FooterOkStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterOkGraphics,
	flags = kVAlignCenter + kHAlignCenter,
}

FooterHintGraphics = {
	"Mastermind/UI/Button/hintnormal",
};

FooterYesGraphics = {
	"Concentration/UI/Button/yesmousenormal",
	"Concentration/UI/Button/yesmousedown",
	"Concentration/UI/Button/yesmouseover"
};

FooterYesStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterYesGraphics,
	flags = kVAlignCenter + kHAlignCenter,
}

MakeDialog
{
	-- Name the modal dialog
	name="MastermindWindow",
	Bitmap
	{
		name="MastermindsWindowBackgroundImage",
		image="Mastermind/UI/frame",
		MastermindWindow
		{
			x=0,
			y=0,
			w=800,
			h=600,
			SetStyle(MM_Style_Button);	
			Button
			{
				x=420,
				y=543,
				font = ButtonFont,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				graphics = MM_Graphics_Button,
				name="pause",
				label="pause",
				type = kPush,
				command=
					function()
						if(WindowActive()) then	
							SendGameMessage("unpause");
							SendGameMessage("pause");
							--DoModal("HiddenObject/script/pause.lua");
						end
					end
			},
			
			SetStyle(MM_Style_Button_Hint);
			Button
			{
				x=557,
				y=543,
				name="hint",
				label="hint",
				font = ButtonFont,
				graphics = FooterHintGraphics,
			},
			
			SetStyle(MM_Style_Skip);
			Button
			{
				x=655,
				y=543,
				font = ButtonFont,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				graphics = MM_Graphics_Skip,
				name="skip",
				label="skip",
				type = kPush,
				command=
					function()
						if(WindowActive()) then	
							--DoModal("HiddenObject/script/skip.lua");
							SendGameMessage('activateSkip');
						end
					end
			},
			SetStyle(FooterYesStyle);
			Button
			{
				x=kCenter -  70,
				y=378,
				font = FooterMenuButtonFont,
				graphics = FooterYesGraphics,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="retry_yes",
				label="yes",
				type = kPush,
				command=
					function()
						EnableWindow( "retry_yes", false);
						EnableWindow( "retry_no", false);
						SendGameMessage("retry");
					end
			},
			SetStyle(FooterYesStyle);
			Button
			{
				x=kCenter + 95,
				y=378,
				font = FooterMenuButtonFont,
				graphics = FooterYesGraphics,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="retry_no",
				label="no",
				type = kPush,
				command=
					function()
						EnableWindow( "retry_yes", false);
						EnableWindow( "retry_no", false);
						EnableWindow( "pause", false);
						EnableWindow( "go", false);
						EnableWindow( "reveal", false);
						EnableWindow( "skip", false);
						EnableWindow( "ok", false);
						EnableWindow( "hint", false);
						SendGameMessage("retryNo");
					end
			},
			SetStyle(FooterOkStyle);
			Button
			{
				x=kCenter,
				y=320,
				font = FooterMenuButtonFont,
				graphics = FooterOkGraphics,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="ok",
				label="ok",
				type = kPush,
				command=
					function()				
						EnableWindow( "ok", false);		
						SendGameMessage("ok");
					end
			},
			SetStyle(MastermindRevealButtonStyle);	
			Button
			{
				x=620,
				y= 55,
				font = RevealButtonFont,
				graphics = MastermindRevealButtonGraphics,
				name="reveal",
				label="reveal",
				type = kPush,
				command=
					function()	
						if(WindowActive()) then	
							SendGameMessage("reveal");
						end
							
					end
			},
			SetStyle(MastermindButtonStyle);	
			Button
			{
				x=620,
				y=450,
				font = GoButtonFont,
				graphics = MastermindButtonGraphics,
				name="go",
				label="go",
				type = kPush,
				command=
					function()					
						if(WindowActive()) then	
							SendGameMessage("go");
						end
					end
			},
		},
	},
}


EnableWindow( "retry_yes", false);
EnableWindow( "retry_no", false);
EnableWindow( "ok", false);
EnableWindow( "pause", false);
EnableWindow( "go", false);
EnableWindow( "reveal", false);
EnableWindow( "skip", false);
EnableWindow( "hint", false);
SetFocus( "MastermindWindow" );	